<?php

if (!defined('IN_VIEWPROFILE')) die(basename(__FILE__));

if (!$profiledata['user_id'] || $profiledata['user_id'] == ANONYMOUS)
{
	message_die(GENERAL_ERROR, 'Invalid user_id');
}

$seeding = $leeching = array();

$profile_user_id = intval($profiledata['user_id']);
$current_time = (isset($_GET['time']) && $_GET['time'] == 'all') ? 0 : time();

// Get username
if (!$username = $profiledata['username'])
{
	message_die(GENERAL_ERROR, 'Tried obtaining data for a non-existent user');
}

if ($profile_user_id == $userdata['user_id'])
{
	$template->assign_vars(array(
		'EDIT_PROF'      => true,
		'L_EDIT_PROF'    => $lang['Edit_profile'],
		'EDIT_PROF_HREF' => append_sid("profile.$phpEx?mode=editprofile"),
	));
}
else
{
	$template->assign_vars(array('EDIT_PROF' => false));
}

// Set tpl vars for bt_userdata
show_bt_userdata($profile_user_id);

if (IS_ADMIN)
{
	$template->assign_vars(array(
		'SHOW_PASSKEY'   => true,
		'S_GEN_PASSKEY'  => "<a href=\"torrent.$phpEx?mode=gen_passkey&amp;u=". $profile_user_id .'&amp;sid='. $userdata['session_id'] .'">'. $lang['Bt_Gen_Passkey_Url'] .'</a>',
		'CAN_EDIT_RATIO' => IS_SUPER_ADMIN,
	));
}
else
{
	$template->assign_vars(array(
		'CAN_EDIT_RATIO' => false,
	));
}

// Auth
$not_auth_forums_sql = ($f = $user->get_not_auth_forums(AUTH_READ)) ? "AND f.forum_id NOT IN($f)" : '';
$datastore->rm('cat_forums');

// Get users active torrents
$sql = 'SELECT f.forum_id, f.forum_name, t.topic_title, tor.size, tr.*
	FROM '. FORUMS_TABLE .' f, '. TOPICS_TABLE .' t, '. BT_TRACKER_TABLE .' tr, '. BT_TORRENTS_TABLE ." tor
	WHERE tr.user_id = $profile_user_id
		AND tr.topic_id = tor.topic_id
		AND tor.topic_id = t.topic_id
		AND t.forum_id = f.forum_id
			$not_auth_forums_sql
	GROUP BY tr.topic_id
	ORDER BY f.forum_name, t.topic_title";

if (!$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, 'Could not query users torrent profile information', '', __LINE__, __FILE__, $sql);
}

if ($rowset = @$db->sql_fetchrowset($result))
{
	$db->sql_freeresult($result);
	$rowset_count = count($rowset);

	for ($i=0; $i<$rowset_count; $i++)
	{
		if ($rowset[$i]['seeder'])
		{
			$seeding[] = $rowset[$i];
		}
		else
		{
			$leeching[] = $rowset[$i];
		}
	}
	unset($rowset);
}

if ($seeding_count = count($seeding))
{
	$template->assign_block_vars('seed', array());

	for ($i=0; $i<$seeding_count; $i++)
	{
		$template->assign_block_vars('seed.seedrow', array(
			'FORUM_NAME'   => htmlCHR($seeding[$i]['forum_name']),
			'TOPIC_TITLE'  => wbr($seeding[$i]['topic_title']),
			'U_VIEW_FORUM' => "viewforum.$phpEx?". POST_FORUM_URL .'='. $seeding[$i]['forum_id'],
			'U_VIEW_TOPIC' => "viewtopic.$phpEx?". POST_TOPIC_URL .'='. $seeding[$i]['topic_id'] .'&amp;spmode=full#seeders',
		));
	}
}
else
{
	$template->assign_block_vars('switch_seeding_none', array());
}

if ($leeching_count = count($leeching))
{
	$template->assign_block_vars('leech', array());

	for ($i=0; $i<$leeching_count; $i++)
	{
		$compl_size = ($leeching[$i]['remain'] && $leeching[$i]['size'] && $leeching[$i]['size'] > $leeching[$i]['remain']) ? ($leeching[$i]['size'] - $leeching[$i]['remain']) : 0;
		$compl_perc = ($compl_size) ? floor($compl_size * 100 / $leeching[$i]['size']) : 0;

		$template->assign_block_vars('leech.leechrow', array(
			'FORUM_NAME'   => htmlCHR($leeching[$i]['forum_name']),
			'TOPIC_TITLE'  => wbr($leeching[$i]['topic_title']),
			'U_VIEW_FORUM' => "viewforum.$phpEx?". POST_FORUM_URL .'='. $leeching[$i]['forum_id'],
			'U_VIEW_TOPIC' => "viewtopic.$phpEx?". POST_TOPIC_URL .'='. $leeching[$i]['topic_id'] .'&amp;spmode=full#leechers',
			'COMPL_PERC'   => $compl_perc,
		));
	}
}
else
{
	$template->assign_block_vars('switch_leeching_none', array());
}

$template->assign_vars(array(
	'USERNAME'   => $username,
	'L_NONE'     => $lang['None'],
	'L_SEEDING'  => '<b>'. $lang['Seeding'] .'</b>'. (($seeding_count) ? "<br />[ <b>$seeding_count</b> ]" : ''),
	'L_LEECHING' => '<b>'. $lang['Leeching'] .'</b>'. (($leeching_count) ? "<br />[ <b>$leeching_count</b> ]" : ''),

	'L_VIEW_TOR_PROF'  => sprintf($lang['Viewing_user_bt_profile'], $username),
	'L_CUR_ACTIVE_DLS' => $lang['Cur_active_dls'],
	'SEED_ROWSPAN'     => ($seeding_count) ? 'rowspan="'. ($seeding_count + 1) .'"' : '',
	'LEECH_ROWSPAN'    => ($leeching_count) ? 'rowspan="'. ($leeching_count + 1) .'"' : '',
));

$template->assign_vars(array('SHOW_SEARCH_DL' => false));

if (!IS_USER || $profile_user_id == $userdata['user_id'])
{
	$page_cfg['dl_links_user_id'] = $profile_user_id;
}

$template->assign_vars(array(
	'U_TORRENT_PROFILE' => append_sid("profile.$phpEx?mode=viewprofile&amp;u=". $profiledata['user_id']) . '#torrent',
	'L_TORRENT_PROFILE' => $lang['View_torrent_profile'],
));

