<?php

if (!defined('IN_TRACKER')) die(basename(__FILE__));

db_init();

$seeder  = ($left == 0) ? 1 : 0;
$stopped = ($event === 'stopped');

// Stopped event
if ($stopped)
{
	$tr_cache->rm(PEER_HASH_PREFIX . $peer_hash);
	if (DBG_LOG) dbg_log(' ', 'stopped');
}

// Get last peer info from DB
if (!$tr_cache->used && !$lp_info)
{
	$lp_info = $db->fetch_row("
		SELECT * FROM ". BT_TRACKER_TABLE ." WHERE peer_hash = '$peer_hash' LIMIT 1
	");

	if (DBG_LOG) dbg_log(' ', '$lp_info-get_from-DB-'. ($lp_info ? 'hit' : 'miss'));
}

if ($lp_info)
{
	if (!$stopped)
	{
		drop_fast_announce($lp_info);
	}

	$user_id  = $lp_info['user_id'];
	$topic_id = $lp_info['topic_id'];
	$releaser = $lp_info['releaser'];
}
else
{
	// Verify if torrent registered on tracker and user authorized
	$info_hash_sql = rtrim($db->escape($info_hash), ' ');
	$passkey_sql   = $db->escape($passkey);

	$row = $db->fetch_row("
		SELECT tor.topic_id, tor.poster_id, u.*
		FROM ". BT_TORRENTS_TABLE ." tor
		LEFT JOIN ". BT_USERS_TABLE ." u ON u.auth_key = '$passkey_sql'
		WHERE tor.info_hash = '$info_hash_sql'
		LIMIT 1
	");

	if (empty($row['topic_id']))
	{
		msg_die('Torrent not registered');
	}
	if (empty($row['user_id']))
	{
		msg_die('Please LOG IN and REDOWNLOAD this torrent (user not found)');
	}

	$user_id  = $row['user_id'];
	$topic_id = $row['topic_id'];
	$releaser = (int) ($user_id == $row['poster_id']);

	// Ratio limits
	if ((TR_RATING_LIMITS || $tr_cfg['limit_concurrent_ips']) && !$stopped)
	{
		$user_ratio = ($row['u_down_total'] && $row['u_down_total'] > MIN_DL_FOR_RATIO) ? ($row['u_up_total'] + $row['u_up_release'] + $row['u_up_bonus']) / $row['u_down_total'] : 1;
		require(TR_ROOT .'includes/tr_ratio.'. PHP_EXT);
	}
}

// Up/Down speed
$speed_up = $speed_down = 0;

if ($lp_info && $lp_info['update_time'] < TIMENOW)
{
	if ($uploaded > $lp_info['uploaded'])
	{
		$speed_up = ceil(($uploaded - $lp_info['uploaded']) / (TIMENOW - $lp_info['update_time']));
	}
	if ($downloaded > $lp_info['downloaded'])
	{
		$speed_down = ceil(($downloaded - $lp_info['downloaded']) / (TIMENOW - $lp_info['update_time']));
	}
}

// Up/Down addition
$up_add = ($lp_info && $uploaded > $lp_info['uploaded']) ? $uploaded - $lp_info['uploaded'] : 0;
$down_add = ($lp_info && $downloaded > $lp_info['downloaded']) ? $downloaded - $lp_info['downloaded'] : 0;

// Insert/update peer info
$peer_info_updated = false;
$update_time = ($stopped) ? 0 : TIMENOW;

if ($lp_info)
{
	$sql  = "UPDATE ". BT_TRACKER_TABLE ." SET update_time = $update_time";

	$sql .= ", seeder = $seeder";
	$sql .= ($releaser != $lp_info['releaser']) ? ", releaser = $releaser" : '';

	$sql .= ($uploaded != $lp_info['uploaded']) ? ", uploaded = $uploaded" : '';
	$sql .= ($downloaded != $lp_info['downloaded']) ? ", downloaded = $downloaded" : '';
	$sql .= ", remain = $left";

	$sql .= ($up_add) ? ", up_add = up_add + $up_add" : '';
	$sql .= ($down_add) ? ", down_add = down_add + $down_add" : '';

	$sql .= ", speed_up = $speed_up";
	$sql .= ", speed_down = $speed_down";

	$sql .= " WHERE peer_hash = '$peer_hash'";
	$sql .= " LIMIT 1";

	$db->query($sql);

	$peer_info_updated = $db->sql_affectedrows();

	if (DBG_LOG) dbg_log(' ', 'this_peer-update'. ($peer_info_updated ? '' : '-FAIL'));
}

if (!$lp_info || !$peer_info_updated)
{
	$columns = 'peer_hash,    topic_id,  user_id,   ip,       port,  seeder,  releaser,  uploaded,  downloaded, remain, speed_up,  speed_down,  up_add,  down_add,  update_time';
	$values = "'$peer_hash', $topic_id, $user_id, '$ip_sql', $port, $seeder, $releaser, $uploaded, $downloaded, $left, $speed_up, $speed_down, $up_add, $down_add, $update_time";

	$db->query("REPLACE INTO ". BT_TRACKER_TABLE ." ($columns) VALUES ($values)");

	if (DBG_LOG) dbg_log(' ', 'this_peer-insert');
}

// Exit if stopped
if ($stopped)
{
	silent_exit();
}

// Store peer info in cache
$lp_info = array(
	'downloaded'  => (float) $downloaded,
	'releaser'    => (int)   $releaser,
	'seeder'      => (int)   $seeder,
	'topic_id'    => (int)   $topic_id,
	'update_time' => (int)   TIMENOW,
	'uploaded'    => (float) $uploaded,
	'user_id'     => (int)   $user_id,
);

$lp_info_cached = $tr_cache->set(PEER_HASH_PREFIX . $peer_hash, $lp_info, PEER_HASH_EXPIRE);

if (DBG_LOG && !$lp_info_cached) dbg_log(' ', '$lp_info-caching-FAIL');

// Get cached output
$output = $tr_cache->get(PEERS_LIST_PREFIX . $topic_id);

if (DBG_LOG) dbg_log(' ', '$output-get_from-CACHE-'. ($output !== false ? 'hit' : 'miss'));

if (!$output)
{
	// Retrieve peers
	$numwant      = (int) $tr_cfg['numwant'];
	$compact_mode = ($tr_cfg['compact_mode'] || !empty($compact));

	$rowset = $db->fetch_rowset("
		SELECT ip, port
		FROM ". BT_TRACKER_TABLE ."
		WHERE topic_id = $topic_id
		ORDER BY RAND()
		LIMIT $numwant
	");

	if ($compact_mode)
	{
		$peers = '';

		foreach ($rowset as $peer)
		{
			$peers .= pack('Nn', ip2long(decode_ip($peer['ip'])), $peer['port']);
		}
	}
	else
	{
		$peers = array();

		foreach ($rowset as $peer)
		{
			$peers[] = array(
				'ip'   => decode_ip($peer['ip']),
				'port' => intval($peer['port']),
			);
		}
	}

	$output = array(
		'interval'     => (int) $announce_interval,
		'min interval' => (int) $announce_interval,
		'peers'        => $peers,
	);

	$peers_list_cached = $tr_cache->set(PEERS_LIST_PREFIX . $topic_id, $output, PEERS_LIST_EXPIRE);

	if (DBG_LOG && !$peers_list_cached) dbg_log(' ', '$output-caching-FAIL');
}

// Return data to client
echo bencode($output);

tracker_exit();
