<?php

$max_forum_name_length = 50;

// ACP Header - START
if (!empty($setmodules))
{
	$module['Users']['Permissions']  = basename(__FILE__) .'?mode=user';
	$module['Groups']['Permissions'] = basename(__FILE__) .'?mode=group';
	return;
}
require('./pagestart.php');
// ACP Header - END

require(INC_DIR .'functions_group.'. PHP_EXT);

$yes_sign = '&radic;';
$no_sign  = 'x';

$group_id = (int) @$_REQUEST['g'];
$user_id  = (int) @$_REQUEST['u'];
$cat_id   = (int) @$_REQUEST['c'];
$mode     = (string) @$_REQUEST['mode'];
$submit   = isset($_POST['submit']);

$group_data = array();

$forum_auth_fields = array(
	'auth_view',
	'auth_read',
	'auth_reply',
	'auth_edit',
	'auth_delete',
	'auth_vote',
	'auth_pollcreate',
	'auth_attachments',
	'auth_download',
	'auth_post',
	'auth_sticky',
	'auth_announce',
);

if ($submit && $mode == 'user')
{
	$this_user_level = null;

	// Obtain relevant data for this user
	if (!$row = get_userdata($user_id))
	{
		bb_die($lang['No_such_user']);
	}
	$this_user_level = $row['user_level'];

	// Get "single_user" group_id for this user
	$sql = "SELECT g.group_id
		FROM ". USER_GROUP_TABLE ." ug, ". GROUPS_TABLE ." g
		WHERE ug.user_id = $user_id
			AND g.group_id = ug.group_id
			AND g.group_single_user = 1";

	if ($row = $db->fetch_row($sql))
	{
		$group_id = $row['group_id'];
	}
	else
	{
		$group_id = create_user_group($user_id);
	}

	if (!$group_id || !$user_id || is_null($this_user_level))
	{
		trigger_error('data missing', E_USER_ERROR);
	}

	// Make user an admin (if already user)
	if (@$_POST['userlevel'] === 'admin')
	{
		if ($userdata['user_id'] == $user_id || $user_id == ANONYMOUS || $user_id == BOT_UID)
		{
			bb_die("Couldn't update admin status");
		}

		$db->query("UPDATE ". USERS_TABLE ." SET user_level = ". ADMIN ." WHERE user_id = $user_id LIMIT 1");

		// Delete any entries in auth_access, they are not required if user is becoming an admin
		delete_permissions($group_id, $user_id);

		$message = $lang['Auth_updated'] .'<br /><br />';
		$message .= sprintf($lang['Click_return_userauth'], '<a href="'. append_sid("admin_ug_auth.$phpEx?mode=$mode") .'">', '</a>') .'<br /><br />';
		$message .= sprintf($lang['Click_return_admin_index'], '<a href="'. append_sid("index.$phpEx?pane=right") .'">', '</a>');

		bb_die($message);
	}
	// Make admin a user (if already admin)
	else if (@$_POST['userlevel'] === 'user')
	{
		// ignore if you're trying to change yourself from an admin to user!
		if ($userdata['user_id'] == $user_id)
		{
			bb_die("Couldn't update admin status<br /><br />Couldn't change yourself from an admin to user");
		}
		// Update users level, reset to USER
		$db->query("UPDATE ". USERS_TABLE ." SET user_level = ". USER ." WHERE user_id = $user_id LIMIT 1");

		delete_permissions($group_id, $user_id);

		$message = $lang['Auth_updated'] .'<br /><br />';
		$message .= sprintf($lang['Click_return_userauth'], '<a href="'. append_sid("admin_ug_auth.$phpEx?mode=$mode") .'">', '</a>') .'<br /><br />';
		$message .= sprintf($lang['Click_return_admin_index'], '<a href="'. append_sid("index.$phpEx?pane=right") .'">', '</a>');

		bb_die($message);
	}

	//
	// Submit new USER permissions
	//
	$auth = array();

	if (is_array(@$_POST['auth']))
	{
		array_deep($_POST['auth'], 'intval');

		foreach ($_POST['auth'] as $f_id => $bf_ary)
		{
			if (array_sum($bf_ary))
			{
				$auth[$f_id] = bit2dec(array_keys($bf_ary, 1));
			}
		}
	}

	delete_permissions($group_id, null, $cat_id);
	store_permissions($group_id, $auth);

	update_user_level($user_id);

	$l_auth_return = ($mode == 'user') ? $lang['Click_return_userauth'] : $lang['Click_return_groupauth'];
	$message = $lang['Auth_updated'] .'<br /><br />';
	$message .= sprintf($l_auth_return, '<a href="'. append_sid("admin_ug_auth.$phpEx?mode=$mode") .'">', '</a>') .'<br /><br />';
	$message .= sprintf($lang['Click_return_admin_index'], '<a href="'. append_sid("index.$phpEx?pane=right") .'">', '</a>');

	bb_die($message);
}
//
// Submit new GROUP permissions
//
else if ($submit && $mode == 'group' && is_array(@$_POST['auth']))
{
	if (!$group_data = get_group_data($group_id))
	{
		bb_die($lang['Group_not_exist']);
	}

	$auth = array();
	array_deep($_POST['auth'], 'intval');

	foreach ($_POST['auth'] as $f_id => $bf_ary)
	{
		if (array_sum($bf_ary))
		{
			$auth[$f_id] = bit2dec(array_keys($bf_ary, 1));
		}
	}

	delete_permissions($group_id, null, $cat_id);
	store_permissions($group_id, $auth);

	update_user_level('all');

	$l_auth_return = $lang['Click_return_groupauth'];
	$message = $lang['Auth_updated'] .'<br /><br />';
	$message .= sprintf($l_auth_return, '<a href="'. append_sid("admin_ug_auth.$phpEx?mode=$mode") .'">', '</a>') .'<br /><br />';
	$message .= sprintf($lang['Click_return_admin_index'], '<a href="'. append_sid("index.$phpEx?pane=right") .'">', '</a>');

	bb_die($message);
}

//
// Front end (changing permissions)
//
if ($mode == 'user' && (!empty($_POST['username']) || $user_id))
{
	$page_cfg['quirks_mode'] = true;

	if (!empty($_POST['username']))
	{
		$this_userdata = get_userdata($HTTP_POST_VARS['username'], true);
		$user_id = $this_userdata['user_id'];
	}
	else
	{
		$this_userdata = get_userdata($user_id);
	}
	if (!$this_userdata)
	{
		bb_die($lang['No_such_user']);
	}

	$forums = $datastore->get('cat_forums');
	$base_url = basename(__FILE__) ."?mode=user&amp;u=$user_id";

	$ug_data = $this_userdata;
	$ug_data['session_logged_in'] = 1;

	$u_access = auth(AUTH_ALL, AUTH_LIST_ALL, $ug_data, array(), UG_PERM_USER_ONLY);
	$g_access = auth(AUTH_ALL, AUTH_LIST_ALL, $ug_data, array(), UG_PERM_GROUP_ONLY);

	foreach ($forums['c'] as $c_id => $c_data)
	{
		$template->assign_block_vars('c', array(
			'CAT_ID'    => $c_id,
			'CAT_TITLE' => $forums['cat_title_html'][$c_id],
			'CAT_HREF'  => "$base_url&amp;c=$c_id",
		));

		if (!$c =& $_REQUEST['c'] OR !in_array($c, array('all', $c_id)))
		{
			continue;
		}

		foreach ($c_data['forums'] as $f_id)
		{
			$f_data = $forums['f'][$f_id];
			$auth_mod = ($u_access[$f_id]['auth_mod'] || $g_access[$f_id]['auth_mod']);
			$disabled = $g_access[$f_id]['auth_mod'];

			$template->assign_block_vars('c.f', array(
				'DISABLED'     => $disabled,
				'FORUM_ID'     => $f_id,
				'FORUM_NAME'   => str_short($forums['forum_name_html'][$f_id], $max_forum_name_length),
				'SF_SPACER'    => ($f_data['forum_parent']) ? HTML_SF_SPACER : '',
				'IS_MODERATOR' => (bool) $auth_mod,
				'MOD_STATUS'   => ($auth_mod) ? $lang['Moderator'] : $lang['NO'],
				'MOD_CLASS'    => ($auth_mod) ? (($disabled) ? 'yesDisabled' : 'yesMOD') : 'noMOD',
				'AUTH_MOD_VAL' => ($auth_mod) ? 1 : 0,
			));

			foreach ($forum_auth_fields as $auth_type)
			{
				$bf_num = $bf['forum_perm'][$auth_type];
				$f_perm = $f_data[$auth_type];
				$auth_via_acl = ($u_access[$f_id][$auth_type] || $g_access[$f_id][$auth_type]);

				if ($f_perm == AUTH_ACL)
				{
					$disabled = ($auth_mod || $g_access[$f_id][$auth_type]);
					$perm_sign = ($auth_via_acl || $auth_mod) ? $yes_sign : $no_sign;
					$acl_class = ($auth_via_acl || $auth_mod) ? 'yes' : 'no';
				}
				else
				{
					$disabled = true;
					$perm_sign = ($auth_via_acl) ? $yes_sign : $no_sign;
					$acl_class = ($auth_via_acl) ? 'yes' : 'no';
				}

				$template->assign_block_vars('c.f.acl', array(
					'DISABLED'    => $disabled,
					'PERM_SIGN'   => $perm_sign,
					'ACL_CLASS'   => $acl_class,
					'FORUM_ID'    => $f_id,
					'ACL_TYPE_BF' => $bf_num,
					'ACL_VAL'     => ($auth_via_acl) ? 1 : 0,
				));
			}
		}
	}

	$template->assign_vars(array(
		'AUTH_MOD_BF' => AUTH_MOD,
	));

	$s_column_span = 2;

	foreach ($forum_auth_fields as $auth_type)
	{
		$template->assign_block_vars('acltype', array(
			'ACL_TYPE_NAME' => preg_replace("#(.{5})#", "\\1<br />", $lang[$auth_type]),
			'ACL_TYPE_BF'   => $bf['forum_perm'][$auth_type],
		));
		$s_column_span++;
	}

	unset($forums, $u_access, $g_access);
	$datastore->rm('cat_forums');

	$s_hidden_fields = '
		<input type="hidden" name="mode" value="'. $mode .'" />
		<input type="hidden" name="'. POST_USERS_URL .'" value="'. $user_id .'" />
	';

	$s_user_type = ($this_userdata['user_level'] == ADMIN) ? '
		<select name="userlevel">
			<option value="admin" selected="selected">'. $lang['Auth_Admin'] .'</option>
			<option value="user">'. $lang['Auth_User'] .'</option>
		</select>
	' : '
		<select name="userlevel">
			<option value="admin">'. $lang['Auth_Admin'] .'</option>
			<option value="user" selected="selected">'. $lang['Auth_User'] .'</option>
		</select>
	';

	$template->assign_block_vars('switch_user_auth', array());

	$template->assign_vars(array(
		'TPL_AUTH_UG_MAIN' => true,

		'USER_OR_GROUPNAME' => $this_userdata['username'],
		'USER_LEVEL'        => $lang['User_Level'] .' : '. $s_user_type,
		'USER_GROUP_MEMBERSHIPS' => $lang['Group_memberships'],
	));

	$template->assign_vars(array(
		'T_USER_OR_GROUPNAME' => $lang['USERNAME'],
		'T_AUTH_TITLE'        => $lang['AUTH_CONTROL_USER'],
		'T_AUTH_EXPLAIN'      => $lang['USER_AUTH_EXPLAIN'],

		'S_COLUMN_SPAN'   => $s_column_span,
		'S_HIDDEN_FIELDS' => $s_hidden_fields,
	));
}
else if ($mode == 'group' && $group_id)
{
	$page_cfg['quirks_mode'] = true;

	if (!$group_data = get_group_data($group_id))
	{
		bb_die($lang['Group_not_exist']);
	}

	$forums = $datastore->get('cat_forums');
	$base_url = basename(__FILE__) ."?mode=group&amp;g=$group_id";

	$ug_data = array('group_id' => $group_id);
	$u_access = auth(AUTH_ALL, AUTH_LIST_ALL, $ug_data);

	foreach ($forums['c'] as $c_id => $c_data)
	{
		$template->assign_block_vars('c', array(
			'CAT_ID'    => $c_id,
			'CAT_TITLE' => $forums['cat_title_html'][$c_id],
			'CAT_HREF'  => "$base_url&amp;c=$c_id",
		));

		if (!$c =& $_REQUEST['c'] OR !in_array($c, array('all', $c_id)) OR empty($c_data['forums']))
		{
			continue;
		}

		foreach ($c_data['forums'] as $f_id)
		{
			$f_data   = $forums['f'][$f_id];
			$auth_mod = $u_access[$f_id]['auth_mod'];

			$template->assign_block_vars('c.f', array(
				'DISABLED'     => false,
				'FORUM_ID'     => $f_id,
				'FORUM_NAME'   => str_short($forums['forum_name_html'][$f_id], $max_forum_name_length),
				'SF_SPACER'    => ($f_data['forum_parent']) ? HTML_SF_SPACER : '',
				'IS_MODERATOR' => (bool) $auth_mod,
				'MOD_STATUS'   => ($auth_mod) ? $lang['Moderator'] : $lang['NO'],
				'MOD_CLASS'    => ($auth_mod) ? 'yesMOD' : 'noMOD',
				'AUTH_MOD_VAL' => ($auth_mod) ? 1 : 0,
			));

			foreach ($forum_auth_fields as $auth_type)
			{
				$bf_num = $bf['forum_perm'][$auth_type];
				$f_perm = $f_data[$auth_type];
				$auth_via_acl = $u_access[$f_id][$auth_type];

				if ($f_perm == AUTH_ACL)
				{
					$disabled = $auth_mod;
					$perm_sign = ($auth_via_acl || $auth_mod) ? $yes_sign : $no_sign;
					$acl_class = ($auth_via_acl || $auth_mod) ? 'yes' : 'no';
				}
				else
				{
					$disabled = true;
					$perm_sign = ($auth_via_acl) ? $yes_sign : $no_sign;
					$acl_class = ($auth_via_acl) ? 'yes' : 'no';
				}

				$template->assign_block_vars('c.f.acl', array(
					'DISABLED'    => $disabled,
					'PERM_SIGN'   => $perm_sign,
					'ACL_CLASS'   => $acl_class,
					'FORUM_ID'    => $f_id,
					'ACL_TYPE_BF' => $bf_num,
					'ACL_VAL'     => ($auth_via_acl) ? 1 : 0,
				));
			}
		}
	}

	$template->assign_vars(array(
		'AUTH_MOD_BF' => AUTH_MOD,
	));

	$s_column_span = 2;

	foreach ($forum_auth_fields as $auth_type)
	{
		$template->assign_block_vars('acltype', array(
			'ACL_TYPE_NAME' => preg_replace("#(.{5})#", "\\1<br />", $lang[$auth_type]),
			'ACL_TYPE_BF'   => $bf['forum_perm'][$auth_type],
		));
		$s_column_span++;
	}

	unset($forums, $ug_data, $u_access);
	$datastore->rm('cat_forums');

	$s_hidden_fields = '
		<input type="hidden" name="mode" value="'. $mode .'" />
		<input type="hidden" name="g" value="'. $group_id .'" />
	';

	$template->assign_vars(array(
		'TPL_AUTH_UG_MAIN'    => true,

		'T_USER_OR_GROUPNAME' => $lang['GROUP_NAME'],
		'USER_LEVEL'          => false,
		'T_AUTH_TITLE'        => $lang['AUTH_CONTROL_GROUP'],
		'T_AUTH_EXPLAIN'      => $lang['GROUP_AUTH_EXPLAIN'],
		'USER_OR_GROUPNAME'   => htmlCHR($group_data['group_name']),
		'S_COLUMN_SPAN'       => $s_column_span,
		'S_HIDDEN_FIELDS'     => $s_hidden_fields,
	));
}
else
{
	// Select a user/group
	if ($mode == 'user')
	{
		$template->assign_vars(array(
			'TPL_SELECT_USER' => true,
			'U_SEARCH_USER'   => BB_ROOT ."search.$phpEx?mode=searchuser",
		));
	}
	else
	{
		$template->assign_vars(array(
			'TPL_SELECT_GROUP' => true,
			'S_GROUP_SELECT'   => get_select('groups'),
		));
	}

	$s_hidden_fields = '<input type="hidden" name="mode" value="'. $mode .'" />';

	$template->assign_vars(array(
		'S_HIDDEN_FIELDS' => $s_hidden_fields,
	));
}

$template->assign_vars(array(
	'YES_SIGN'      => $yes_sign,
	'NO_SIGN'       => $no_sign,
	'T_MOD_YES'     => $lang['Moderator'],
	'T_MOD_NO'      => $lang['NO'],
	'S_AUTH_ACTION' => append_sid("admin_ug_auth.$phpEx"),
	'SELECTED_CAT'  => !empty($_REQUEST['c']) ? $_REQUEST['c'] : '',
	'U_ALL_FORUMS'  => !empty($base_url) ? "$base_url&amp;c=all" : '',
));

print_page('admin_ug_auth.tpl', 'admin');
