<?php

// Based on "Rebuild Search Mod" by chatasos [http://www.phpbb.com/phpBB/viewtopic.php?t=329629]

// ACP Header - START
if (!empty($setmodules))
{
	$module['General']['Rebuild_Search_Index'] = basename(__FILE__);
	return;
}
require('./pagestart.php');
// ACP Header - END

require(INC_DIR .'bbcode.'. PHP_EXT);
require(DEFAULT_LANG_DIR .'lang_admin_rebuild_search.'. PHP_EXT);

define('REBUILD_SEARCH_ABORTED',   0);  // when the user aborted the processing
define('REBUILD_SEARCH_PROCESSED', 1);  // when a batch of posts has been processed
define('REBUILD_SEARCH_COMPLETED', 2);  // when all the db posts have been processed

//
// Define initial vars
//
$def_post_limit   = 50;
$def_refresh_rate = 3;
$def_time_limit   = ($sys_time_limit = @ini_get('max_execution_time')) ? $sys_time_limit : 30;

$last_session_data = get_rebuild_session_details('last', 'all');
$last_session_id   = (int) $last_session_data['rebuild_session_id'];
$max_post_id       = get_latest_post_id();
$start_time        = TIMENOW;

$mode = (string) @$_REQUEST['mode'];

// check if the user has choosen to stop processing
if (isset($_REQUEST['cancel_button']))
{
	// update the rebuild_status
	if ($last_session_id)
	{
		$db->query("
			UPDATE ". SEARCH_REBUILD_TABLE ." SET
				rebuild_session_status = ". REBUILD_SEARCH_ABORTED ."
			WHERE rebuild_session_id = $last_session_id
		");
	}

	$message = sprintf($lang['Rebuild_search_aborted'], $last_session_data['end_post_id']) .'<br /><br />'. sprintf($lang['Click_return_rebuild_search'], '<a href="'.append_sid("admin_rebuild_search.$phpEx").'">', '</a>');
	message_die(GENERAL_MESSAGE, $message);
}

// from which post to start processing
$start = abs(intval(@$_REQUEST['start']));

// get the total number of posts in the db
$total_posts = get_total_posts();

// clear the search tables and clear mode (delete or truncate)
$clear_search = isset($_REQUEST['clear_search']) ? (int) $_REQUEST['clear_search'] : 0;

// get the number of total/session posts already processed
$total_posts_processed = ( $start != 0 ) ? get_total_posts('before', $last_session_data['end_post_id']) : 0;
$session_posts_processed = ( $mode == 'refresh' ) ? get_processed_posts('session') : 0;

// find how many posts aren't processed
$total_posts_processing = $total_posts - $total_posts_processed;

// how many posts to process in this session
if ($session_posts_processing = @intval($_REQUEST['session_posts_processing']))
{
	if ($mode == 'submit')
	{
		// check if we passed over total_posts just after submitting
		if ($session_posts_processing + $total_posts_processed > $total_posts)
		{
			$session_posts_processing = $total_posts - $total_posts_processed;
		}
	}
	// correct it when posts are deleted during processing
	$session_posts_processing = ($session_posts_processing > $total_posts) ? $total_posts : $session_posts_processing;
}
else
{
	// if we have finished, get all the posts, else only the remaining
	$session_posts_processing = (!$total_posts_processing) ? $total_posts : $total_posts_processing;
}

// how many posts to process per cycle
$post_limit = isset($_REQUEST['post_limit']) ? (int) $_REQUEST['post_limit'] : $def_post_limit;

// correct the post_limit when we pass over it
if ( $session_posts_processed + $post_limit > $session_posts_processing )
{
	$post_limit = $session_posts_processing - $session_posts_processed;
}

// how much time to wait per cycle
if (isset($_REQUEST['time_limit']))
{
	$time_limit = (int) $_REQUEST['time_limit'];
}
else
{
	$time_limit = $def_time_limit;
	$time_limit_explain = $lang['Time_limit_explain'];

	// check for safe mode timeout
	if ( ini_get('safe_mode') )
	{
		// get execution time
		$max_execution_time = ini_get('max_execution_time');
		$time_limit_explain .= '<br />' . sprintf($lang['Time_limit_explain_safe'], $max_execution_time);

		if ( $time_limit > $max_execution_time )
		{
			$time_limit = $max_execution_time;
		}
	}

	// check for webserver timeout (IE returns null)
	if ( isset($_SERVER["HTTP_KEEP_ALIVE"]) )
	{
		// get webserver timeout
		$webserver_timeout = intval($_SERVER["HTTP_KEEP_ALIVE"]);
		$time_limit_explain .= '<br />' . sprintf($lang['Time_limit_explain_webserver'], $webserver_timeout);

		if ( $time_limit > $webserver_timeout )
		{
			$time_limit = $webserver_timeout;
		}
	}
}

// how much time to wait between page refreshes
$refresh_rate = isset($_REQUEST['refresh_rate']) ? (int) $_REQUEST['refresh_rate'] : $def_refresh_rate;

// check if the user gave wrong input
if ($mode == 'submit')
{
	if ($session_posts_processing <= 0 || $post_limit <= 0 || $refresh_rate <= 0 || $time_limit <=0)
	{
		$message = $lang['Wrong_input'] .'<br /><br />'. sprintf($lang['Click_return_rebuild_search'], '<a href="'.append_sid("admin_rebuild_search.$phpEx").'">', '</a>');
		message_die(GENERAL_MESSAGE, $message);
	}
}

//---------------------------------------------------------------------
// Main code starts from here
//

// Increase maximum execution time in case of a lot of posts, but don't complain about it if it isn't allowed.
@set_time_limit($time_limit + 20);

// check if we are should start processing
if ($mode == 'submit' || $mode == 'refresh')
{
	// check if we are in the beginning of processing
	if ($start == 0)
	{
		$last_session_data = get_empty_last_session_data();
		clear_search_tables($clear_search);
	}

	// get the db sizes
	list($search_data_size, $search_index_size, $search_tables_size) = get_db_sizes();

	// get the post subject/text of each post
	$result = $db->query("
		SELECT
			pt.post_id,
			pt.post_text, pt.bbcode_uid,
			IF(p.post_id = t.topic_first_post_id, t.topic_title, '') AS post_subject
		FROM
			". POSTS_TEXT_TABLE ." pt,
			". POSTS_TABLE      ." p,
			". TOPICS_TABLE     ." t
		WHERE p.post_id = pt.post_id
			AND t.topic_id = p.topic_id
			AND p.poster_id NOT IN(". BOT_UID .")
			AND pt.post_id >= $start
		ORDER BY pt.post_id ASC
		LIMIT $post_limit
	");

	$expire_time = $start_time + $time_limit - 5;
	$start_post_id = $end_post_id = $num_rows = 0;
	$timer_expired = false;
	$words_sql = array();

	while ($row = $db->fetch_next($result) AND !$timer_expired)
	{
		@set_time_limit(600);
		$start_post_id = ($num_rows == 0) ? $row['post_id'] : $start_post_id;
		$end_post_id   = $row['post_id'];

		// Get search words
		$words_sql[] = array(
			'post_id'      => (int) $row['post_id'],
			'search_words' => add_search_words($row['post_id'], stripslashes($row['post_text']), stripslashes($row['post_subject']), $row['bbcode_uid'], true),
		);

		$timer_expired = (time() > $expire_time);
		$num_rows++;
	}

	// Store search words
	if ($words_sql)
	{
		$db->query("REPLACE INTO ". POSTS_SEARCH_TABLE . $db->build_array('MULTI_INSERT', $words_sql));
	}

	// find how much time the last cycle took
	$last_cycle_time = intval(time() - $start_time);

	// check if we had any data
	if ($num_rows != 0)
	{
		if ($mode == 'submit')
		{
			// insert a new session entry
			$args = $db->build_array('INSERT', array(
				'end_post_id'     => (int) $end_post_id,
				'end_time'        => (int) time(),
				'last_cycle_time' => (int) $last_cycle_time,
				'session_time'    => (int) $last_cycle_time,
				'session_posts'   => (int) $num_rows,
				'session_cycles'  => (int) 1,
				'start_post_id'   => (int) $start_post_id,
				'start_time'      => (int) $start_time,
				'search_size'     => (int) $search_tables_size,
				'rebuild_session_status' => REBUILD_SEARCH_PROCESSED,
			));
			$db->query("REPLACE INTO ". SEARCH_REBUILD_TABLE . $args);
		}
		else  // refresh
		{
			// update the last session entry
			$db->query("
				UPDATE ". SEARCH_REBUILD_TABLE ." SET
					end_post_id     = $end_post_id,
					end_time        = ". time() .",
					last_cycle_time = $last_cycle_time,
					session_time    = session_time + $last_cycle_time,
					session_posts   = session_posts + $num_rows,
					session_cycles  = session_cycles + 1,
					rebuild_session_status = ". REBUILD_SEARCH_PROCESSED ."
				WHERE rebuild_session_id = $last_session_id
			");
		}
	}

	$last_session_data = get_rebuild_session_details('last', 'all');
	$template->assign_vars(array('TPL_REBUILD_SEARCH_PROGRESS' => true));

	$processing_messages = '';
	$processing_messages .= ($timer_expired) ? sprintf($lang['Timer_expired'], time() - $start_time) : '';
	$processing_messages .= ($start == 0 && $clear_search) ? $lang['Cleared_search_tables'] : '';

	// check if we have reached the end of our post processing
	$session_posts_processed = get_processed_posts('session');
	$total_posts_processed = get_total_posts('before', $last_session_data['end_post_id']);
	$total_posts = get_total_posts();

	if ( $session_posts_processed < $session_posts_processing && $total_posts_processed < $total_posts )
	{
		$form_parameters  = '&start='.($end_post_id+1);
		$form_parameters .= '&session_posts_processing='.$session_posts_processing;
		$form_parameters .= '&post_limit='.$post_limit;
		$form_parameters .= '&time_limit='.$time_limit;
		$form_parameters .= '&refresh_rate='.$refresh_rate;

		$form_action = append_sid('admin_rebuild_search.'.$phpEx.'?mode=refresh'.$form_parameters);
		$next_button = $lang['Next'];
		$progress_bar_img = $images['progress_bar'];

		$processing_messages .= sprintf($lang['Processing_next_posts'], $post_limit);

		// create the meta tag for refresh
		$template->assign_vars(array(
			'META'          => '<meta http-equiv="refresh" content="'.$refresh_rate.';url='.$form_action.'">',
			'CANCEL_BUTTON' => true,
		));
	}
	else  // end of processing
	{
		$form_action = append_sid("admin_rebuild_search.$phpEx");
		$next_button = $lang['Finished'];
		$progress_bar_img = $images['progress_bar_full'];

		$processing_messages .= ( $session_posts_processed < $session_posts_processing ) ? sprintf($lang['Deleted_posts'], $session_posts_processing - $session_posts_processed) : '';
		$processing_messages .= ( $total_posts_processed == $total_posts ) ? $lang['All_posts_processed'] : $lang['All_session_posts_processed'];

		// if we have processed all the db posts we need to update the rebuild_status
		$db->query("UPDATE ". SEARCH_REBUILD_TABLE ." SET
				rebuild_session_status = ". REBUILD_SEARCH_COMPLETED ."
			WHERE rebuild_session_id = $last_session_id
				AND end_post_id = $max_post_id
		");

		// optimize all search tables when finished
		$table_ary = array(POSTS_SEARCH_TABLE);

		foreach ($table_ary as $table)
		{
			$db->query("ANALYZE  TABLE $table");
			$db->query("OPTIMIZE TABLE $table");
		}

		$processing_messages .= '<br />' . $lang['All_tables_optimized'];
	}

	// calculate the percent
	$session_percent = ($session_posts_processed / $session_posts_processing) * 100;
	$total_percent = ($total_posts_processed / $total_posts) * 100;

	// get the db sizes
	list($search_data_size, $search_index_size, $search_tables_size) = get_db_sizes();

	// calculate the final (estimated) values
	$final_search_tables_size = '';

	if ($search_tables_size)
	{
		$start_search_tables_size = $last_session_data['search_size'];
		$final_search_tables_size = $start_search_tables_size + round(($search_tables_size - $start_search_tables_size) * (100 / $session_percent));
	}

	// calculate various times
	$session_time = $last_session_data['session_time'];
	$session_average_cycle_time = round($session_time / $last_session_data['session_cycles']);
	$session_estimated_time = round($session_time * (100 / $session_percent)) - $session_time;

	// create the percent boxes
	create_percent_box('session', create_percent_color($session_percent), $session_percent);
	create_percent_box('total', create_percent_color($total_percent), $total_percent);

	$template->assign_vars(array(
		'L_REBUILD_SEARCH_PROGRESS' => $lang['Rebuild_search_progress'],
		'L_REBUILD_SEARCH'          => $lang['Rebuild_search'],
		'L_NEXT'                    => $next_button,
		'L_PROCESSING'              => $lang['Processing'],

		'L_PROCESSING_POST_DETAILS' => $lang['Processing_post_details'],
		'L_PROCESSED_POSTS'         => $lang['Processed_posts'],
		'L_PERCENT'                 => $lang['Percent'],
		'L_CURRENT_SESSION'         => $lang['Current_session'],
		'L_TOTAL'                   => $lang['Total'],

		'L_PROCESSING_TIME_DETAILS' => $lang['Processing_time_details'],
		'L_PROCESSING_TIME'         => $lang['Processing_time'],
		'L_TIME_LAST_POSTS'         => sprintf($lang['Time_last_posts'], $num_rows),
		'L_TIME_BEGINNING'          => $lang['Time_from_the_beginning'],
		'L_TIME_AVERAGE'            => $lang['Time_average'],
		'L_TIME_ESTIMATED'          => $lang['Time_estimated'],

		'L_DATABASE_SIZE_DETAILS'   => $lang['Database_size_details'],
		'L_SIZE_CURRENT'            => $lang['Size_current'],
		'L_SIZE_ESTIMATED'          => $lang['Size_estimated'],
		'L_SIZE_SEARCH_TABLES'      => $lang['Size_search_tables'],
		'L_SIZE_DATABASE'           => $lang['Size_database'],

		'L_ACTIVE_PARAMETERS'       => $lang['Active_parameters'],
		'L_STARTING_POST_ID'        => $lang['Starting_post_id'],
		'L_POSTS_LAST_CYCLE'        => $lang['Posts_last_cycle'],
		'L_TIME_LIMIT'              => $lang['Time_limit'],
		'L_BOARD_STATUS'            => $lang['Board_status'],

		'L_ESTIMATED_VALUES'        => $lang['Info_estimated_values'],

		'PROCESSING_POSTS'          => sprintf($lang['Processed_post_ids'], $start_post_id, $end_post_id),
		'PROCESSING_MESSAGES'       => $processing_messages,
		'PROGRESS_BAR_IMG'          => $progress_bar_img,

		'SESSION_DETAILS'           => sprintf($lang['Process_details'], $session_posts_processed - $num_rows + 1, $session_posts_processed, $session_posts_processing),
		'SESSION_PERCENT'           => sprintf($lang['Percent_completed'], round($session_percent, 2)),

		'TOTAL_DETAILS'             => sprintf($lang['Process_details'], $total_posts_processed - $num_rows + 1, $total_posts_processed, $total_posts),
		'TOTAL_PERCENT'             => sprintf($lang['Percent_completed'], round($total_percent, 2)),

		'LAST_CYCLE_TIME'           => delta_time(time()),
		'SESSION_TIME'              => delta_time($last_session_data['start_time']),
		'SESSION_AVERAGE_CYCLE_TIME'=> delta_time($session_average_cycle_time, 0),
		'SESSION_ESTIMATED_TIME'    => delta_time($session_estimated_time, 0),

		'SEARCH_TABLES_SIZE'        => humn_size($search_tables_size),
		'FINAL_SEARCH_TABLES_SIZE'  => humn_size($final_search_tables_size),
		'SEARCH_DATA_SIZE'          => humn_size($search_data_size),
		'SEARCH_INDEX_SIZE'         => humn_size($search_index_size),

		'START_POST'   => $last_session_data['start_post_id'],
		'POST_LIMIT'   => $num_rows,
		'TIME_LIMIT'   => $time_limit,
		'REFRESH_RATE' => $refresh_rate,

		'S_REBUILD_SEARCH_ACTION' => $form_action,
	));
}
else  // show the input page
{
	// create the page
	// used only with the select input
	$post_limit_hidden = ( $def_post_limit > $total_posts ) ? $total_posts : $def_post_limit;

	$s_hidden_fields = '<input type="hidden" name="post_limit_stored" value="'.$post_limit_hidden.'" />';
	$s_hidden_fields .= '<input type="hidden" name="total_posts_stored" value="'.$total_posts.'" />';

	$next_start_post_id = 0;
	$last_saved_processing = '';
	$clear_search_disabled = '';

	if ($last_session_data['rebuild_session_id'])
	{
		$last_saved_post_id = $last_session_data['end_post_id'];
		$next_start_post_id = $last_saved_post_id + 1;
		$last_saved_date = create_date($board_config['default_dateformat'], $last_session_data['end_time'], $board_config['board_timezone']);

		// check our last status
		if ( $last_session_data['rebuild_session_status'] == REBUILD_SEARCH_PROCESSED )
		{
			$last_saved_processing = sprintf($lang['Info_processing_stopped'], $last_saved_post_id, $total_posts_processed, $last_saved_date);
			$clear_search_disabled = 'disabled="disabled"';

			$template->assign_block_vars("start_select_input", array());
		}
		elseif ( $last_session_data['rebuild_session_status'] == REBUILD_SEARCH_ABORTED )
		{
			$last_saved_processing = sprintf($lang['Info_processing_aborted'], $last_saved_post_id, $total_posts_processed, $last_saved_date);
			// check if the interrupted cycle has finished
			if ( time() - $last_session_data['end_time'] < $last_session_data['last_cycle_time'] )
			{
				$last_saved_processing .= '<br />'.$lang['Info_processing_aborted_soon'];
			}
			$clear_search_disabled = 'disabled="disabled"';

			$template->assign_block_vars("start_select_input", array());
		}
		else  // when finished
		{
			if ( $last_session_data['end_post_id'] < $max_post_id )
			{
				$last_saved_processing = sprintf($lang['Info_processing_finished_new'], $last_saved_post_id, $total_posts_processed, $last_saved_date, ($total_posts - $total_posts_processed));
				$clear_search_disabled = 'disabled="disabled"';

				$template->assign_block_vars("start_select_input", array());
			}
			else
			{
				$last_saved_processing = sprintf($lang['Info_processing_finished'], $total_posts, $last_saved_date);

				$template->assign_block_vars("start_text_input", array());
			}
		}

		$template->assign_block_vars("last_saved_info", array());
	}
	else
	{
		$template->assign_block_vars("start_text_input", array());
	}

	// create the output of page
	$template->assign_vars(array(
		'TPL_REBUILD_SEARCH_MAIN' => true,

		'L_REBUILD_SEARCH'      => $lang['Rebuild_search'],
		'L_REBUILD_SEARCH_DESC' => $lang['Rebuild_search_desc'],

		'L_STARTING_POST_ID'         => $lang['Starting_post_id'],
		'L_STARTING_POST_ID_EXPLAIN' => $lang['Starting_post_id_explain'],

		'L_START_OPTION_BEGINNING'   => $lang['Start_option_beginning'],
		'L_START_OPTION_CONTINUE'    => $lang['Start_option_continue'],

		'L_CLEAR_SEARCH_TABLES'         => $lang['Clear_search_tables'],
		'L_CLEAR_SEARCH_TABLES_EXPLAIN' => $lang['Clear_search_tables_explain'],

		'L_CLEAR_SEARCH_NO'        => $lang['Clear_search_no'],
		'L_CLEAR_SEARCH_DELETE'    => $lang['Clear_search_delete'],
		'L_CLEAR_SEARCH_TRUNCATE'  => $lang['Clear_search_truncate'],

		'L_NUM_OF_POSTS'           => $lang['Num_of_posts'],
		'L_NUM_OF_POSTS_EXPLAIN'   => $lang['Num_of_posts_explain'],

		'L_POSTS_PER_CYCLE'        => $lang['Posts_per_cycle'],
		'L_POSTS_PER_CYCLE_EXPLAIN'=> $lang['Posts_per_cycle_explain'],

		'L_REFRESH_RATE'           => $lang['Refresh_rate'],
		'L_REFRESH_RATE_EXPLAIN'   => $lang['Refresh_rate_explain'],

		'L_TIME_LIMIT'             => $lang['Time_limit'],
		'L_TIME_LIMIT_EXPLAIN'     => $time_limit_explain,

		'L_PROCESSING'             => $lang['Processing'],

		'NEXT_START_POST_ID'       => $next_start_post_id,
		'CLEAR_SEARCH_DISABLED'    => $clear_search_disabled,
		'SESSION_POSTS_PROCESSING' => $session_posts_processing,
		'POST_LIMIT'               => $post_limit,
		'REFRESH_RATE'             => $refresh_rate,
		'TIME_LIMIT'               => $time_limit,

		'LAST_SAVED_PROCESSING'    => $last_saved_processing,

		'SESSION_ID'               => $userdata['session_id'],

		'S_HIDDEN_FIELDS'          => $s_hidden_fields,
		'S_REBUILD_SEARCH_ACTION'  => append_sid("admin_rebuild_search.$phpEx?mode=submit"),
	));
}

print_page('admin_rebuild_search.tpl', 'admin');

//
// Functions
//
function get_db_sizes ()
{
	global $db;

	$search_data_size = $search_index_size = 0;
	$search_table_like = $db->escape(POSTS_SEARCH_TABLE);

	$sql = "SHOW TABLE STATUS FROM ". $db->selected_db ." LIKE '$search_table_like'";

	foreach ($db->fetch_rowset($sql) as $row)
	{
		$search_data_size += $row['Data_length'];
		$search_index_size += $row['Index_length'];
	}

	return array($search_data_size, $search_index_size, $search_data_size+$search_index_size);
}

// get the latest post_id in the forum
function get_latest_post_id ()
{
	$row = $GLOBALS['db']->fetch_row("SELECT MAX(post_id) as post_id FROM ". POSTS_TEXT_TABLE);

	return (int) $row['post_id'];
}

function get_empty_last_session_data ()
{
	return array(
		'rebuild_session_id' => 0,
		'start_post_id'      => 0,
		'end_post_id'        => 0,
		'start_time'         => 0,
		'end_time'           => 0,
		'last_cycle_time'    => 0,
		'session_time'       => 0,
		'session_posts'      => 0,
		'session_cycles'     => 0,
		'search_size'        => 0,
		'rebuild_session_status' => REBUILD_SEARCH_COMPLETED,
	);
}

// get some or all of the rebuild details of a specific session or of the last session
// $id is the id or the 'last' id
// $details is one of the fields or 'all' of them
function get_rebuild_session_details ($id, $details = 'all')
{
	$session_details = get_empty_last_session_data();

	if ($id != 'last')
	{
		$sql = "SELECT * FROM ". SEARCH_REBUILD_TABLE ." WHERE rebuild_session_id = $id";
	}
	else
	{
		$sql = "SELECT * FROM ". SEARCH_REBUILD_TABLE ." ORDER BY rebuild_session_id DESC LIMIT 1";
	}

	if ($row = $GLOBALS['db']->fetch_row($sql))
	{
		$session_details = ($details == 'all') ? $row : $row[$details];
	}

	return $session_details;
}

// get the number of processed posts in the last session or in all sessions
// 'total' to get the sum of posts of all sessions
// 'session' to get the posts of the last session
function get_processed_posts ($mode = 'session')
{
	global $db, $last_session_data;

	if ($mode == 'total')
	{
		$sql = "SELECT SUM(session_posts) as posts FROM ". SEARCH_REBUILD_TABLE;
		$row = $db->fetch_row($sql);
	}
	else
	{
		$row['posts'] = $last_session_data['session_posts'];
	}

	return (int) $row['posts'];
}

// how many posts are in the db before or after a specific post_id
// after/before require and the post_id
function get_total_posts ($mode = 'after', $post_id = 0)
{
	if ($post_id)
	{
		$sql = "SELECT COUNT(post_id) as total_posts FROM " . POSTS_TEXT_TABLE . "
			WHERE post_id " . (($mode == 'after') ? '>= ' : '<= ' ) . (int) $post_id;
	}
	else
	{
		$sql = "SELECT COUNT(*) as total_posts FROM " . POSTS_TEXT_TABLE;
	}

	$row = $GLOBALS['db']->fetch_row($sql);

	return (int) $row['total_posts'];
}

function clear_search_tables ($mode = '')
{
	global $db;

	$db->query("DELETE FROM ". SEARCH_REBUILD_TABLE);

	if ($mode)
	{
		$table_ary = array(POSTS_SEARCH_TABLE);

		foreach ($table_ary as $table)
		{
			$sql = (($mode == 1) ? "DELETE FROM " : "TRUNCATE TABLE ") . $table;
			$db->query($sql);
		}
	}
}

// Create the percent color
// We use an array with the color percent limits.
// One color stays constantly at FF when the percent is between its limits
// and we adjust the other 2 accordingly to percent, from 200 to 0.
// We limit the result to 200, in order to avoid white (255).
function create_percent_color($percent)
{
	$percent_ary = array(
		'r' => array(86, 100),
		'g' => array(0,  50),
		'b' => array(51, 85),
	);

	foreach ($percent_ary as $key => $value)
	{
		if ( $percent <= $value[1] )
		{
			$percent_color = create_color($key, round(200-($percent-$value[0])*(200/($value[1]-$value[0]))));
			break;
		}
	}

	return $percent_color;
}

// create the hex representation of color
function create_color($mode, $code)
{
	return (($mode == 'r') ? 'FF': sprintf("%02X", $code)) . (($mode == 'g') ? 'FF': sprintf("%02X", $code)) . (($mode == 'b') ? 'FF': sprintf("%02X", $code));
}

// create the percent bar & box
function create_percent_box($box, $percent_color, $percent_width)
{
	global $template;

	if ($box == 'session')
	{
		$template->assign_vars(array(
			'SESSION_PERCENT_BOX'   => true,
			'SESSION_PERCENT_COLOR' => $percent_color,
			'SESSION_PERCENT_WIDTH' => round($percent_width),
		));
	}
	else
	{
		$template->assign_vars(array(
			'TOTAL_PERCENT_BOX'   => true,
			'TOTAL_PERCENT_COLOR' => $percent_color,
			'TOTAL_PERCENT_WIDTH' => round($percent_width),
		));
	}
}