<?php

//
// Sorry, for bad english. :)
//
//
// Usage of profiler script:
//  1. Setup 'php_dbg' module on your php.ini
//  2. Run DBG Listener
//  3. Include this file at the end of you script
//  4. To enable profiling use you script with parameters: ?DBGSESSID=1@clienthost:7869;p=1
//     P.S.: see parameters bellow
//  5. To disable profiling use you script with parameters: ?DBGSESSID=-1
//
//  P.S. All DBGSESSID parameters stored in cookie. You must run in once to enable, and
//       once to disable.
//


// *****************************************************************************
// DBGSESSID Usage:
// *****************************************************************************
//
// DBGSESSID=nnn[@host][:port][;{flags}]
//
// where
//
// nnn - is session ID (any positive number or zero)
//  NOTE: negative values prohibit debug session to run and drops cookie
//
// host - is host name or IP address of the host where your run PHPED IDE.
//  You may set clienthost which is a keyword, in this case debugger looks for
//  proper client IP address automatically.
//
// flags - set of the following flags delimited with commas:
//  s=skip - skip number of HTTP requests before actual session should run
//  d={0|1} - start debug session
//  p={0|1} - start profiler session
//
// For example:
//  DBGSESSID=1@clienthost:7869;d=1,p=1
//  DBGSESSID=1;d=1,p=0
//  DBGSESSID=1:7869;d=1,p=0,s=5
//


// *****************************************************************************
// PHP_DBG Module functions
// *****************************************************************************
//
// ---------------------------------------------------
// get all profiler results
// ---------------------------------------------------
// int dbg_get_profiler_results(array &$results);
//
// return int: count of $results
//
// $results = array( 'mod_no'    => array(),
//					 'line_no'   => array(),
//					 'hit_count' => array(),
//					 'tm_max'    => array(),
//					 'tm_min'    => array(),
//					 'tm_sum'    => array());
//
//
// ---------------------------------------------------
// get all modules name
// ---------------------------------------------------
// int dbg_get_all_module_names(array &$results);
//
// return int: count of $results
//
// $results = array( 'mod_no'	=> array(),
//					 'mod_name' => array());
//
//
// ---------------------------------------------------
// get module name
// ---------------------------------------------------
// int dbg_get_module_name(int $mod_no, string &$results);
//
// return int: 0 - error
//             1 - success
//
// $results = module name
//
//
// ---------------------------------------------------
// get all context (function name) for given module
// ---------------------------------------------------
// int dbg_get_all_contexts(int $mod_no, array &$results);
//
// if $mod_no = 0 it returns all contexts
//
// return int: count of $results
//
// $results = array( 'ctx_no'	=> array(),
//					 'mod_no'   => array(),
//					 'ctx_name' => array());
//
//
// ---------------------------------------------------
// get context name
// ---------------------------------------------------
// int dbg_get_context_name(int $ctx_no, string &$function_name);
//
// return int: 0 - error
//             1 - success
//
// $function_name = function name
//
//
// ---------------------------------------------------
// get all source lines for given module
// ---------------------------------------------------
// int dbg_get_all_source_lines(int $mod_no, array &$results);
//
// if $mod_no = 0 it returns all source lines for all contexts
//
// return int: count of $results
//
// $results = array( 'ctx_no'	=> array(),
//					 'mod_no'   => array(),
//					 'line_no'  => array());
//
//
// ---------------------------------------------------
// get context id for given module and line
// ---------------------------------------------------
// int dbg_get_source_context(int $mod_no, int $line_no, int &$ctx_no);
//
// return int: 0 - error
//             1 - success
//
// $ctx_no = function name
//


// *****************************************************************************
// profiler.php
// *****************************************************************************

function dbg_profile()
{
	$dbg_results = array();
	$dbg_modules = array();
	$dbg_context = array();
	$dbg_lines   = array();

	dbg_get_profiler_results(&$dbg_results);
	dbg_get_all_module_names(&$dbg_modules);
	dbg_get_all_contexts(0, &$dbg_context);
	dbg_get_all_source_lines(0, &$dbg_lines);

	$dbg_complete = array();
	foreach ($dbg_lines['mod_no'] as $id => $val)
	{
		$dbg_complete[$val][$dbg_lines['line_no'][$id]] = $dbg_lines['ctx_no'][$id];
	}

	$results = array();

	foreach ($dbg_results['line_no'] as $idx => $line_no)
	{
		$mod_no   = $dbg_results['mod_no'][$idx];
		$mod_name = $dbg_modules['mod_name'][$mod_no - 1];

		$hit_cnt  = $dbg_results["hit_count"][$idx];
		$time_sum = $dbg_results["tm_sum"][$idx] * 1000;
		$time_min = $dbg_results["tm_min"][$idx] * 1000;
		$time_max = $dbg_results["tm_max"][$idx] * 1000;

		$ctx_id = $dbg_complete[$mod_no][$line_no];

		$ctx_name = $dbg_context['ctx_name'][$ctx_id - 1];

		if ($ctx_name == "")
		{
			$ctx_name = '::main';
		}

		$cont =& $results[$ctx_name];

		if (!@$cont) $cont = array(
										"file" => $mod_name,
										'hit_cnt' => 0,
										'time_sum' => 0,
										'lines' => array()
										);

		$cont['time_sum'] += $time_sum;

		$cont['lines'][$line_no] = array(
										"hit_cnt"  => $hit_cnt,
										"time_sum" => $time_sum,
										"time_min" => $time_min,
										"time_max" => $time_max,
										);
	}

	uasort($results, 'dbg_profile_cmp');

	foreach ($results as $ctx => $data)
	{
		uasort($results[$ctx]['lines'], 'dbg_profile_cmp');
	}

	return $results;
}


function dbg_profile_cmp($x,$y)
{
	if ($x["time_sum"] == $y["time_sum"]) return 0;
	return ($x["time_sum"] > $y["time_sum"]) ? -1 : 1;
}


// input:
//   $contexts        -     
//
//   $lines_detail    -       
//                          
//
//   $min_line_detail -       
//                       
//

function dbg_draw_contexts($contexts, $lines_detail = 15, $min_line_detail = 0.01)
{

	$total_time = 0;
	$total_files = 0;

	$files = array();

	foreach ($contexts as $context => $data)
	{
		$total_time += $data['time_sum'];
		if (!@$files[$data['file']])
		{
			$total_files ++;
			$files[$data['file']] = basename($data['file']);
		}
	}

	echo "
		<div align='left'>
		<table cellspacing='1' cellpadding='2' border='0' style='font: 9px courier;' width='100%'>
			<tr>
				<td colspan='7' style='background: #808080; color: #FFFFFF;' align='center'> : ".$total_files."</td>
			</tr>
			<tr>
				<td colspan='7' style='background: #808080; color: #FFFFFF;' align='center'> : ".implode(", ",$files)."</td>
			</tr>
			<tr>
				<td colspan='7' style='background: #808080; color: #FFFFFF;' align='center'> : ".round($total_time / 1000,3)." sec.</td>
			</tr>
			<tr>
				<td style='background: #808080; color: #FFFFFF;' align='center'> file </td>
				<td style='background: #808080; color: #FFFFFF;' align='center'> function </td>
				<td style='background: #808080; color: #FFFFFF;' align='center'> hit_cnt </td>
				<td style='background: #808080; color: #FFFFFF;' align='center'> time </td>
				<td style='background: #808080; color: #FFFFFF;' align='center'> min </td>
				<td style='background: #808080; color: #FFFFFF;' align='center'> max </td>
				<td style='background: #808080; color: #FFFFFF;' align='center'> % time </td>
			</tr>";

	$idx = 0;
	foreach ($contexts as $context => $data)
	{
		$bk = ($idx++ & 1) ? "#F0F0F0" : "#D0D0D0";

		$file = basename($data['file']);

		$p_time = round(100 * $data['time_sum'] / $total_time,3);

		echo "
			<tr>
				<td style='background: $bk' align='left'>$file</td>
				<td style='background: $bk' align='left'>$context</td>
				<td style='background: $bk' align='center'>--</td>
				<td style='background: $bk' align='right'>".round($data['time_sum'],4)."</td>
				<td style='background: $bk' align='right'>--</td>
				<td style='background: $bk' align='right'>--</td>
				<td style='background: $bk' align='right'>$p_time</td>
			</tr>";

		if ($idx-1 < $lines_detail)
		{
			$i = 0;

			foreach ($data['lines'] as $l => $d)
			{
				$p_time = round(100 * $d['time_sum'] / $total_time,3);

				if ($i++ > 20 || $d['time_sum'] < $min_line_detail) break;

				echo "
					<tr>
						<td style='background: $bk'>...</td>
						<td style='background: $bk' align='left'>&nbsp; &nbsp; line $l</td>
						<td style='background: $bk' align='center'>$d[hit_cnt]</td>
						<td style='background: $bk' align='right'>".round($d['time_sum'],4)."</td>
						<td style='background: $bk' align='right'>".round($d['time_min'],4)."</td>
						<td style='background: $bk' align='right'>".round($d['time_max'],4)."</td>
						<td style='background: $bk' align='right'>$p_time</td>
					</tr>";
			}
		}
	}

	echo "</table></div>";
}

dbg_draw_contexts(dbg_profile());

?>