<?php

// ACP Header - START
if (!empty($setmodules))
{
	$module['Forums']['Permissions'] = basename(__FILE__);
	return;
}
require('./pagestart.php');
// ACP Header - END

$forum_auth_fields = array(
	'auth_view',
	'auth_read',
	'auth_reply',
	'auth_edit',
	'auth_delete',
	'auth_vote',
	'auth_pollcreate',
	'auth_attachments',
	'auth_download',
	'auth_post',
	'auth_sticky',
	'auth_announce',
);

//                            View       Read       Reply      Edit      Delete      Vote       Poll    PostAttach  DownAttach  PostTopic  Sticky    Announce
$simple_auth_ary = array(
/* Public */     0 => array(AUTH_ALL,  AUTH_ALL,  AUTH_ALL,  AUTH_REG,  AUTH_REG,  AUTH_REG,  AUTH_REG,  AUTH_REG,  AUTH_ALL,  AUTH_ALL,  AUTH_MOD,  AUTH_MOD), // Public
/* Reg */        1 => array(AUTH_ALL,  AUTH_ALL,  AUTH_REG,  AUTH_REG,  AUTH_REG,  AUTH_REG,  AUTH_REG,  AUTH_REG,  AUTH_REG,  AUTH_REG,  AUTH_MOD,  AUTH_MOD), // Registered
/* Reg [Hid] */  2 => array(AUTH_REG,  AUTH_REG,  AUTH_REG,  AUTH_REG,  AUTH_REG,  AUTH_REG,  AUTH_REG,  AUTH_REG,  AUTH_REG,  AUTH_REG,  AUTH_MOD,  AUTH_MOD), // Registered [Hidden]
/* Priv */       3 => array(AUTH_REG,  AUTH_ACL,  AUTH_ACL,  AUTH_ACL,  AUTH_ACL,  AUTH_ACL,  AUTH_ACL,  AUTH_ACL,  AUTH_ACL,  AUTH_ACL,  AUTH_MOD,  AUTH_MOD), // Private
/* Priv [Hid] */ 4 => array(AUTH_ACL,  AUTH_ACL,  AUTH_ACL,  AUTH_ACL,  AUTH_ACL,  AUTH_ACL,  AUTH_ACL,  AUTH_ACL,  AUTH_ACL,  AUTH_ACL,  AUTH_MOD,  AUTH_MOD), // Private [Hidden]
/* MOD */        5 => array(AUTH_REG,  AUTH_MOD,  AUTH_MOD,  AUTH_MOD,  AUTH_MOD,  AUTH_MOD,  AUTH_MOD,  AUTH_MOD,  AUTH_MOD,  AUTH_MOD,  AUTH_MOD,  AUTH_MOD), // Moderators
/* MOD [Hid] */  6 => array(AUTH_MOD,  AUTH_MOD,  AUTH_MOD,  AUTH_MOD,  AUTH_MOD,  AUTH_MOD,  AUTH_MOD,  AUTH_MOD,  AUTH_MOD,  AUTH_MOD,  AUTH_MOD,  AUTH_MOD), // Moderators [Hidden]
);

$simple_auth_types = array(
	$lang['Public'],
	$lang['Registered'],
	$lang['Registered'] .' ['. $lang['Hidden'] .']',
	$lang['Private'],
	$lang['Private']    .' ['. $lang['Hidden'] .']',
	$lang['MODERATORS'],
	$lang['MODERATORS'] .' ['. $lang['Hidden'] .']',
);

$field_names = array();
foreach ($forum_auth_fields as $auth_type)
{
	$field_names[$auth_type] = $lang[$auth_type];
}

$forum_auth_levels = array('ALL',   'REG',    'PRIVATE', 'MOD',    'ADMIN');
$forum_auth_const  = array(AUTH_ALL, AUTH_REG, AUTH_ACL,  AUTH_MOD, AUTH_ADMIN);

if (@$_REQUEST[POST_FORUM_URL])
{
	$forum_id = (int) $_REQUEST[POST_FORUM_URL];
	$forum_sql = "WHERE forum_id = $forum_id";
}
else
{
	unset($forum_id);
	$forum_sql = '';
}

if( isset($HTTP_GET_VARS['adv']) )
{
	$adv = intval($HTTP_GET_VARS['adv']);
}
else
{
	unset($adv);
}

//
// Start program proper
//
if( isset($HTTP_POST_VARS['submit']) )
{
	$sql = '';

	if(!empty($forum_id))
	{
		if(isset($HTTP_POST_VARS['simpleauth']))
		{
			$simple_ary = $simple_auth_ary[intval($HTTP_POST_VARS['simpleauth'])];

			for($i = 0; $i < count($simple_ary); $i++)
			{
				$sql .= ( ( $sql != '' ) ? ', ' : '' ) . $forum_auth_fields[$i] . ' = ' . $simple_ary[$i];
			}

			if (is_array($simple_ary))
			{
			$sql = "UPDATE " . FORUMS_TABLE . " SET $sql WHERE forum_id = $forum_id";
			}
		}
		else
		{
			for($i = 0; $i < count($forum_auth_fields); $i++)
			{
				$value = intval($HTTP_POST_VARS[$forum_auth_fields[$i]]);

				if ( $forum_auth_fields[$i] == 'auth_vote' )
				{
					if ( $HTTP_POST_VARS['auth_vote'] == AUTH_ALL )
					{
						$value = AUTH_REG;
					}
				}

				$sql .= ( ( $sql != '' ) ? ', ' : '' ) .$forum_auth_fields[$i] . ' = ' . $value;
			}

			$sql = "UPDATE " . FORUMS_TABLE . " SET $sql WHERE forum_id = $forum_id";
		}

		if ( $sql != '' )
		{
			if ( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, 'Could not update auth table', '', __LINE__, __FILE__, $sql);
			}
		}

		$forum_sql = '';
		$adv = 0;
	}

	$datastore->update('cat_forums');
	$message = $lang['Forum_auth_updated'] . '<br /><br />' . sprintf($lang['Click_return_forumauth'],  '<a href="'."admin_forumauth.$phpEx".'">', "</a>");
	message_die(GENERAL_MESSAGE, $message);

} // End of submit

//
// Get required information, either all forums if
// no id was specified or just the requsted if it
// was
//
$forum_rows = $db->fetch_rowset("SELECT * FROM ". FORUMS_TABLE ." $forum_sql");

if (empty($forum_id))
{
	// Output the selection table if no forum id was specified
	$template->assign_vars(array(
		'TPL_AUTH_SELECT_FORUM' => true,

		'L_AUTH_TITLE'   => $lang['Auth_Control_Forum'],
		'L_AUTH_EXPLAIN' => $lang['Forum_auth_explain'],
		'L_AUTH_SELECT'  => $lang['Select_a_Forum'],

		'S_AUTH_ACTION'  => "admin_forumauth.$phpEx",
		'S_AUTH_SELECT'  => get_forum_select('admin', 'f', null, 80),
	));

}
else
{
	// Output the authorisation details if an id was specified
	$forum_name = $forum_rows[0]['forum_name'];

	@reset($simple_auth_ary);
	while( list($key, $auth_levels) = each($simple_auth_ary))
	{
		$matched = 1;
		for($k = 0; $k < count($auth_levels); $k++)
		{
			$matched_type = $key;

			if ( $forum_rows[0][$forum_auth_fields[$k]] != $auth_levels[$k] )
			{
				$matched = 0;
			}
		}

		if ( $matched )
		{
			break;
		}
	}

	//
	// If we didn't get a match above then we
	// automatically switch into 'advanced' mode
	//
	if ( !isset($adv) && !$matched )
	{
		$adv = 1;
	}

	$s_column_span = 0;

	if ( empty($adv) )
	{
		$simple_auth = '<select name="simpleauth">';

		for($j = 0; $j < count($simple_auth_types); $j++)
		{
			$selected = ( $matched_type == $j ) ? ' selected="selected"' : '';
			$simple_auth .= '<option value="' . $j . '"' . $selected . '>' . $simple_auth_types[$j] . '</option>';
		}

		$simple_auth .= '</select>';

		$template->assign_block_vars('forum_auth', array(
			'CELL_TITLE' => $lang['Simple_mode'],
			'S_AUTH_LEVELS_SELECT' => $simple_auth,
		));

		$s_column_span++;
	}
	else
	{
		//
		// Output values of individual
		// fields
		//
		for($j = 0; $j < count($forum_auth_fields); $j++)
		{
			$custom_auth[$j] = '&nbsp;<select name="' . $forum_auth_fields[$j] . '">';

			for($k = 0; $k < count($forum_auth_levels); $k++)
			{
				$selected = ( $forum_rows[0][$forum_auth_fields[$j]] == $forum_auth_const[$k] ) ? ' selected="selected"' : '';
				$custom_auth[$j] .= '<option value="' . $forum_auth_const[$k] . '"' . $selected . '>' . $lang['Forum_' . $forum_auth_levels[$k]] . '</option>';
			}
			$custom_auth[$j] .= '</select>&nbsp;';

			$cell_title = $field_names[$forum_auth_fields[$j]];

			$template->assign_block_vars('forum_auth', array(
				'CELL_TITLE' => $cell_title,
				'S_AUTH_LEVELS_SELECT' => $custom_auth[$j],
			));

			$s_column_span++;
		}
	}

	$adv_mode = ( empty($adv) ) ? '1' : '0';
	$switch_mode = "admin_forumauth.$phpEx?f=$forum_id&amp;adv=$adv_mode";
	$switch_mode_text = ( empty($adv) ) ? $lang['Advanced_mode'] : $lang['Simple_mode'];
	$u_switch_mode = '<a href="' . $switch_mode . '">' . $switch_mode_text . '</a>';

	$s_hidden_fields = '<input type="hidden" name="' . POST_FORUM_URL . '" value="' . $forum_id . '">';

	$template->assign_vars(array(
		'TPL_EDIT_FORUM_AUTH' => true,

		'FORUM_NAME' => htmlCHR($forum_name),

		'L_AUTH_TITLE' => $lang['Auth_Control_Forum'],
		'L_AUTH_EXPLAIN' => $lang['Forum_auth_explain'],

		'U_SWITCH_MODE' => $u_switch_mode,

		'S_FORUMAUTH_ACTION' => "admin_forumauth.$phpEx",
		'S_COLUMN_SPAN' => $s_column_span,
		'S_HIDDEN_FIELDS' => $s_hidden_fields,
	));
}

print_page('admin_forumauth.tpl', 'admin');

