<?
/*

Copyright (c) 2002. Dmitri Dmitrienko

LICENCE:
 This source file is subject to Mozilla Public License (MPL)

INSTALL:
 Add this file as auto_append_file in php.ini
 So, it will work for every running query.

 Instead of echoing results might be saved to any database
 or sent by e-mail for later analyzing.

HISTORY:
 Aug 9, 2002. Created
 Sep 9, 2002. Updated according to new profiler API

AUTHOR:
 Dmitri Dmitrienko <dd@cron.ru>
 Written and debugged using PHPEd 3.1 http://www.nusphere.com
*/

function dbg_dump_profiling_results() {

  dbg_get_profiler_results(&$dbg_prof_results);

  echo "<br><table width=1000 cellspacing=0 cellpadding=2 style='font:8pt courier'>
    <thead>
    <tr style='background:#808080; color:#FFFFFF'>
      <td> module </td>
      <td> line </td>
      <td> hits </td>
      <td> time/hit, ms </td>
      <td> total time, ms </td>
      <td> min time, ms </td>
      <td> max time, ms </td>
      <td> context ID </td>
      <td> context </td>
    </tr></thead>
    <tbody style='vertical-align: top'>";
  foreach ($dbg_prof_results["line_no"] as $idx => $line_no) {
    $mod_no = $dbg_prof_results["mod_no"][$idx];
    dbg_get_module_name($mod_no, &$mod_name);
    if (strpos("!".$mod_name, "prof_results.php") > 0) continue;

    $hit_cnt = $dbg_prof_results["hit_count"][$idx];

    $time_sum = $dbg_prof_results["tm_sum"][$idx] * 1000;
    $time_avg_hit = $time_sum / $hit_cnt;
    $time_min = $dbg_prof_results["tm_min"][$idx] * 1000;
    $time_max = $dbg_prof_results["tm_max"][$idx] * 1000;

    $time_sum = sprintf("%.3f", $time_sum);
    $time_avg_hit = sprintf("%.3f", $time_avg_hit);
    $time_min = sprintf("%.3f", $time_min);
    $time_max = sprintf("%.3f", $time_max);

    dbg_get_source_context($mod_no, $line_no, &$ctx_id);
    if (dbg_get_context_name($ctx_id, &$ctx_name) && strcmp($ctx_name,"") == 0)
      $ctx_name = "::main";

    $bk = "#ffffff";
    if (($idx & 1) == 0)
      $bk = "#e0e0e0";

    echo "<tr style='background:$bk'>
      <td>$mod_name</td>
      <td>$line_no</td>
      <td>$hit_cnt</td>
      <td>$time_avg_hit</td>
      <td>$time_sum</td>
      <td>$time_min</td>
      <td>$time_max</td>
      <td>$ctx_id</td>
      <td>$ctx_name</td>
    </tr>";
  }
  echo "</tbody></table>";
}

dbg_dump_profiling_results();

?>