<?php

if (!defined('IN_PHPBB'))
{
	exit;
}

require(INC_TR_DB_INIT);

$current_time = (isset($HTTP_GET_VARS['time']) && $HTTP_GET_VARS['time'] == 'all') ? 0 : time();

// Tracker config
if (!$tr_cfg)
{
	require_once(INC_TR_FUNC_CACHE);

	$tr_cfg = get_config_ary(BT_CONFIG_TABLE);

	if (TR_USE_CACHE && check_cache_dir(CACHE_DIR))
	{
		$cfg_cached = write_cfg_to_cache(CACHE_TR_CFG, $tr_cfg, '$tr_cfg');
	}
}

// Output mode
init_output();

// Exit if tracker is disabled
if ($tr_cfg['off'])
{
	error_exit($tr_cfg['off_reason'], '', '', 'off');
}

// Init received variables
if (isset($HTTP_GET_VARS['info_hash']))
{
	$info_hash = unesc($HTTP_GET_VARS['info_hash']);
}
else
{
	unset($info_hash);
}

// Verify if torrent registered on tracker and user authorized
if (isset($info_hash))
{
	if (strlen($info_hash) != 20)
	{
		error_exit('Invalid info_hash');
	}


	$sql = 'SELECT torrent_id, complete_count, complete_count_guest
		FROM '. BT_TORRENTS_TABLE ."
		WHERE info_hash = '".rtrim(sqlesc($info_hash), ' ')."'
		LIMIT 1";

	if (!$result = $db->sql_query($sql))
	{
		error_exit('DB error', __FILE__, __LINE__, 'db', 'info_hash_md5='. md5($info_hash));
	}

	$row = $db->sql_fetchrow($result);

	if (!$row || !isset($row['torrent_id']))
	{
		error_exit('Torrent not registered');
	}

	$torrent_id  = $row['torrent_id'];
	$downloaded = $row['complete_count'] + $row['complete_count_guest'];

	// Retrieve peers
	$sql = "SELECT SUM(seeder) AS complete, COUNT(*) as peers FROM ". BT_TRACKER_TABLE ." WHERE torrent_id = $torrent_id AND expire_time > $current_time";
	if (!$result = $db->sql_query($sql)) { error_exit('DB error', __FILE__, __LINE__, 'db'); }
	$row = $db->sql_fetchrow($result);
	$complete = $row['complete'];
	$incomplete = $row['peers'] - $row['complete'];

	// Return data to client
	$files[$info_hash] = array('complete' => intval($complete), 'incomplete' => intval($incomplete), 'downloaded' => intval($downloaded));

	echo bencode(array('files' => $files));

	send_data_to_client();

}
else
{
	$torrents = array();

	$sql = 'SELECT info_hash, torrent_id, complete_count, complete_count_guest
		FROM '. BT_TORRENTS_TABLE ;

	if (!$result = $db->sql_query($sql))
	{
		error_exit('DB error', __FILE__, __LINE__, 'db', 'info_hash_md5='. md5($info_hash));
	}

	if ($rowset = @$db->sql_fetchrowset($result))
	{
		foreach ($rowset as $i => $torrents)
		{
			$info_hash = $torrents['info_hash'];
			$torrent_id = $torrents['torrent_id'];
			$downloaded = $torrents['complete_count'] + $torrents['complete_count_guest'];

			// Retrieve peers
			$sql = "SELECT SUM(seeder) AS complete, COUNT(*) as peers FROM ". BT_TRACKER_TABLE ." WHERE torrent_id = $torrent_id AND expire_time > $current_time";
			if (!$result = $db->sql_query($sql)) { error_exit('DB error', __FILE__, __LINE__, 'db'); }
			$row = $db->sql_fetchrow($result);
			$complete = $row['complete'];
			$incomplete = $row['peers'] - $row['complete'];

			$files[$info_hash] = array(
				'complete' => intval($complete),
				'incomplete' => intval($incomplete),
				'downloaded' => intval($downloaded)
			);
		}
	}

	echo bencode(array('files' => $files));

	send_data_to_client();

}

?>
